{smcl}
{* *! version 1.0.0 13sep2010}
{cmd:help x12}
{hline}

{title:x12}

{phang}
{bf:x12} {hline 2} Seasonally Adjust a Variable


{title:Syntax}

{p 8 17 2}
{cmd:x12} {year} {date_2} {variable} {periodicity}

{synopt:{year}}This is a variable containing the "year" component.{p_end}
{synopt:{date_2}}This is a variable containing the secondary component of the date.
This is usually a month or quarter. This must be in numeric format, so for monthly
data this variable would contain values 1-12, and for quarterly data this variable would contain 
values 1-4.{p_end}
{synopt:{variable}} This is the name of the variable that you want to seasonally adjust. {p_end}
{synopt:{periodicity}} This defines how you are splitting up the calendar year. For example,
for monthly data, this would be "12". For quarterly data, this would be "4". If you
were dividing up the year into 8 equal sections, this would be "8".{p_end}
{synoptline}
{p2colreset}

{title:Description}
{pstd}
{cmd:x12} performs x12 seasonal adjustment on a single variable of interest.
The .ado file outsheets the variable, writes a spec file, and then runs the x12-ARIMA 
program from the Census Bureau. Note that x12 can only handle less than 600 observations
by default. Also, note that x12 does not like missing values.

{title:Example}
{pstd}

adopath ++ "S:\EricHsu\Programs\X12_ARIMA"

clear
set haverdll "C:\DLX\dlxapi32\dlxapi32.dll"
cd M:\Haver\DLX\DATA
haver use LAPRIV using USECON

gen year = year(dofm(time))
gen month = month(dofm(time))
keep if year > 1950
x12 year month LAPRIV 12


{title:Also see}
{psee}
x12: {browse "S:\EricHsu\Programs\X12_ARIMA\x12a\docs\x12adocV03.pdf":x12 documentation}
{p_end}